<?php
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $nama_gudang = $_POST['nama_gudang'];
    $tahun = $_POST['tahun'];

    $conn = new mysqli("localhost", "root", "", "stock_opname");
    if ($conn->connect_error) {
        die("Koneksi gagal: " . $conn->connect_error);
    }

    // Cek apakah kombinasi sudah ada
    $check = $conn->prepare("SELECT id_gudang FROM gudang_tahun WHERE nama_gudang = ? AND tahun = ?");
    $check->bind_param("si", $nama_gudang, $tahun);
    $check->execute();
    $result = $check->get_result();

    if ($result->num_rows > 0) {
        $row = $result->fetch_assoc();
        $id_gudang = $row['id_gudang'];
    } else {
        // Insert jika belum ada
        $stmt = $conn->prepare("INSERT INTO gudang_tahun (nama_gudang, tahun) VALUES (?, ?)");
        $stmt->bind_param("si", $nama_gudang, $tahun);
        if ($stmt->execute()) {
            $id_gudang = $stmt->insert_id; // ambil id baru
        } else {
            die("Gagal menyimpan data: " . $stmt->error);
        }
        $stmt->close();
    }

    $check->close();
    $conn->close();

    // Redirect ke form_opname
    header("Location: form_opname.php?id_gudang=$id_gudang&tahun=$tahun");
    exit();
}
?>

<!-- Form -->
<h2>Input Gudang dan Tahun</h2>
<form method="post">
    <label>Nama Gudang:</label><br>
    <input type="text" name="nama_gudang" required><br><br>

    <label>Tahun:</label><br>
    <input type="number" name="tahun" required><br><br>

    <button type="submit">Simpan & Lanjut</button>
</form>
